#! /usr/bin/python
#
# This script clones each project from GIT
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://vadev.mantech.com darmbrust
#
import subprocess
import os

projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-cpt',
			'ISAAC-term-convert-cvx',
			'ISAAC-term-convert-nucc',
			'ISAAC-term-convert-hl7v3',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme',
			'apache_extensions',
			'aitc_install']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

gitHubURL = 'https://vadev.mantech.com:4848/git/r/'

for project in projects:
		if os.path.isdir(os.getcwd() + os.sep + project + '.git')== False:
				print(os.getcwd() + os.sep + project + ".git does not exist")
				thisProjectUrl = gitHubURL + project + '.git'
				print("==================================")
				print("Mirroring Latest From " + project)
				
				git("clone", "--mirror", thisProjectUrl)
				print("==================================")
				print("");
		else:
				print(project + " already exists in " + os.getcwd())
